module net.BurtonRadons.spyl.expressionCall;

private import net.BurtonRadons.spyl.expressionUnary;
private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** A function call expression. */
class CallExpression : UnaryExpression
{
    private import net.BurtonRadons.spyl.statement;
    
    Expression [] arguments; /**< Arguments to the function call. */
    BlockStatement content; /**< Potentially a body. */
    
    /** Assign the parameters. */
    this (Mark mark, Expression a)
    {
        super (mark, a);
    }
    
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression [] arguments, BlockStatement content)
    {
        this (mark, a);
        this.arguments = arguments;
        this.content = content;
    }
    
    override Value evaluate (Scope scope)
    {
        Value value = a.evaluate (scope);
        Value [] arguments = new Value [this.arguments.length];
        
        for (int c; c < arguments.length; c ++)
            arguments [c] = this.arguments [c].evaluate (scope);
        
        return value.call (arguments);
    }
    
    override char [] toString ()
    {
        char [] text;
        
        text = subString (a) ~ " (";
        for (int c; c < arguments.length; c ++)
        {
            if (c)
                text ~= ", ";
            text ~= arguments [c].toString ();
        }
        
        text ~= ")";
        assert (!content);
        return text;
    }
    
    override int precedence ()
    {
        return Precedence.Postfix;
    }
}
